/** <!------------------------------------------------------------------------->
*
*  @file StateManager_generated.h
*
*  @creationDate 22 November 2024 14:08:31
*
*  @brief Header definition of a shared state management.
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2024, dSPACE GmbH. All rights reserved.
*
*<!-------------------------------------------------------------------------->*/

/* File ID: 96fb9801-49e4-422e-8738-cbd43a29eda6 */
#pragma once

#include <Platform_Types.h>

typedef void(*StateChangedCallback)(uint32, uint8, uint8);


typedef struct {
    uint8 oldStateTransition;
    uint8 newStateTransition;
} stateTransitionType;

typedef struct {
    StateChangedCallback* Callback;
    stateTransitionType* StateTransitions;
    uint32 NumberOfCallbacks;
} CallbackAndStateTransition;

typedef struct {
    StateChangedCallback* Callback;
    uint32 NumberOfCallbacks_WO_Transitions;
} CallbacksWoTransitions;

typedef struct {
    uint32 Size;
    uint32 Capacity;
    CallbackAndStateTransition* callbackAndStateTransitions;
    CallbacksWoTransitions* callbackWoStateTransitions;
} StateTransitionAndCallbackList;

#define BUSCFG_STATE_DISABLED 0
#define BUSCFG_STATE_ENABLED  1
#define BUSCFG_STATE_RXONLY   2

#define COM_CONTROLLER_DISABLE 0
#define COM_CONTROLLER_ENABLE  1

/* PDU transmission control, 
   indicates TX supression due to PDU enable or J1939 connection locking */
#define PDU_TX_ENABLED          0x00
#define PDU_TX_DISABLED         0x01
#define PDU_TX_LOCKED           0x02

/* Macro for checking whether there is a BusCfgEnable state transition from DISABLED or RX-ONLY to ENABLED. */
#define BUSCFG_STATE_CHANGED_TO_ENABLED(newState, oldState) ((oldState == BUSCFG_STATE_DISABLED || oldState == BUSCFG_STATE_RXONLY) && newState == BUSCFG_STATE_ENABLED)
/* Macro for checking whether there is a BusCfgEnable state transition from DISABLED to RX-ONLY or ENABLED or from RX-ONLY TO ENABLED. */
#define BUSCFG_STATE_CHANGED_TO_OPERATIONAL(newState, oldState) ((oldState == BUSCFG_STATE_DISABLED && (newState > oldState)) || (oldState == BUSCFG_STATE_RXONLY && newState == BUSCFG_STATE_ENABLED))

/* Macro for checking whether there is a BusCfgEnable state transition from DISABLED to ENABLED. */
#define BUSCFG_STATE_CHANGED_FROM_DISABLE_TO_ENABLED(newState, oldState) ((oldState == BUSCFG_STATE_DISABLED) && (newState == BUSCFG_STATE_ENABLED))
/* Macro for checking whether there is a BusCfgEnable state transition from DISABLED to RXONLY. */
#define BUSCFG_STATE_CHANGED_FROM_DISABLE_TO_RXONLY(newState, oldState) ((oldState == BUSCFG_STATE_DISABLED) && (newState == BUSCFG_STATE_RXONLY))

/* Macro for checking whether there is a BusCfgEnable state transition from ENABLED to DISABLE. */
#define BUSCFG_STATE_CHANGED_FROM_ENABLE_TO_DISABLE(newState, oldState) ((oldState == BUSCFG_STATE_ENABLED) && (newState == BUSCFG_STATE_DISABLED))
/* Macro for checking whether there is a BusCfgEnable state transition from ENABLED to RXONLY. */
#define BUSCFG_STATE_CHANGED_FROM_ENABLE_TO_RXONLY(newState, oldState) ((oldState == BUSCFG_STATE_ENABLED) && (newState == BUSCFG_STATE_RXONLY))

/* Macro for checking whether there is a BusCfgEnable state transition from RXONLY to ENABLED. */
#define BUSCFG_STATE_CHANGED_FROM_RXONLY_TO_ENABLED(newState, oldState) ((oldState == BUSCFG_STATE_RXONLY) && (newState == BUSCFG_STATE_ENABLED))
/* Macro for checking whether there is a BusCfgEnable state transition from RXONLY to DISABLED. */
#define BUSCFG_STATE_CHANGED_FROM_RXONLY_TO_DISABLE(newState, oldState) ((oldState == BUSCFG_STATE_RXONLY) && (newState == BUSCFG_STATE_DISABLED))

/* Macro for checking whether comController enable state changed from FALSE to TRUE. */
#define COMCTRL_ENABLE_STATE_CHANGED_FROM_FALSE_TO_TRUE(newState) (newState > 0)

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */ 

void StateManager_RegisterCallback_SingleTransition(uint32 index, StateChangedCallback callback, uint8 expectedOldState, uint8 expectedNewState);
void StateManager_RegisterCallback_MultipleTransitions(uint32 index, StateChangedCallback callback, uint8 NumberOfExpectedTransitions, uint8 expectedTransitions[][2]);
void StateManager_RegisterCallback_NoTransitions(uint32 index, StateChangedCallback callback);
void StateManager_UnregisterCallback_SingleTransition(uint32 index, StateChangedCallback callback, uint8 expectedOldState, uint8 expectedNewState);
void StateManager_UnregisterCallback_MultipleTransitions(uint32 index, StateChangedCallback callback, uint8 NumberOfExpectedTransitions, uint8 expectedTransitions[][2]);
void StateManager_UnregisterCallback_NoTransitions(uint32 index, StateChangedCallback callback);
uint8 StateManager_GetState(uint32 index);
void StateManager_SetState(uint32 index, uint8 state);
void StateManager_StateManagerInit(void);
void StateManager_SetState_Mutex(uint32 index, uint8 state);
void StateManager_GetState_SysIntCodeMap(uint32 index, void* State);
void StateManager_DecrementCounterState(uint32 index);
void StateManager_ResetCounterState(uint32 index);

/*SysInt code mapping region*/
#ifdef __cplusplus
}
#endif /* __cplusplus */ 

